<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Programação Demanda</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2511.19.1">
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2511.19.1">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.2511.19.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2511.19.1">
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2511.19.1" />
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2511.19.1">
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2511.19.1">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2511.19.1" />
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2511.19.1">
    <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2511.19.1">
    <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2511.19.1">
    <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.2511.19.1">
    <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.2511.19.1">
    <link rel="stylesheet" type="text/css" href="dist/css/sisplan.adjustDataTableButtons.css?versao=3.2511.19.1" />
    <link rel="stylesheet" type="text/css" href="dist/css/sisplan.newColorsButtons.css?versao=3.2511.19.1" />

    <style>
        .bordaCampos {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            padding-top: 2%;
            padding-bottom: 0%;
        }

        .bordaCampos:first-child {
            display: flex;
            flex-direction: row;
            flex-wrap: wrap;
            justify-content: flex-end;
            align-items: center;
        }

        .border-Field .textoBorda {
            font-size: 1.0em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1.0px solid var(--font-color) !important;
            padding: 0 1.0em 1.0em 1.0em !important;
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            padding-bottom: 0px !important;
        }

        .custom-scroll {
            max-height: 200px;
            overflow-y: auto;
            width: 300px;
        }

        .btnSubVerificaOpcoes {
            border-color: transparent !important;
            background-color: transparent !important;
            margin-left: 3px;
            color: #5d5d5d;
        }

        html.theme-dark .btnSubVerificaOpcoes {
            color: #fff;
        }

        .btn.btn-secondary.btnSubVerificaOpcoes.dropdown-toggle::after {
            display: none;
        }

        #tabelaPedidos td, #tabelaConsumos td {
            padding-top: 7px;
            padding-bottom: 7px;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <main class="wrapper">

        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Programação Demanda</h1>
                            <button class="btnTutorial" id="tutorial">
                                <i class="fas fa-question-circle"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="container-fluid">

                    <nav style="margin-top: 15px;" style="z-index:9999 !important">
                        <div class="nav nav-tabs" id="nav-tab" role="tablist" style="text-decoration: none">
                            <a class="nav-link abaLink active" id="tabTabelaProdutos" data-toggle="tab" href="#divTabelaProdutos" role="tab" aria-controls="divTabelaProdutos" aria-selected="true">Produtos</a>
                            <a class="nav-link abaLink" id="tabTabelaPedidos" data-toggle="tab" href="#divTabelaPedidos" role="tab" aria-controls="divTabelaPedidos" aria-selected="false">Pedidos</a>
                            <a class="nav-link abaLink d-none" id="tabTabelaConsumos" data-toggle="tab" href="#divTabelaConsumos" role="tab" aria-controls="divTabelaConsumos" aria-selected="false">Consumos</a>
                        </div>
                    </nav>

                    <div class="tab-content" id="nav-tabContent">
                        <div class="tab-pane fade show active" id="divTabelaProdutos" role="tabpanel" aria-labelledby="tabTabelaProdutos">
                            <div class="row card form-group">
                                <div class="col-12 d-flex justify-content-between" style="margin-top: 8px; padding-left: 20px; padding-right: 20px; z-index:9999;">
                                    <div class="d-flex align-items-center listaBotoes ajustaBotao[ultimo]" style="z-index:9999 !important">
                                        <button class="btn btn-sisp btnFiltros" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
                                        <button class="btn btn-sisp btn-danger marginBtnH" id="btnImprimir"><i class="fas fa-print"></i> Imprimir</button>
                                        <button class="btn btn-sisp btnVerde marginBtnH" id="btnGerarProjecao" type="button"> <i class="fas fa-project-diagram" disabled></i> Gerar Projeção </button>
                                        <button class="btn btn-sisp btn-primary marginBtnH" id="btnGerarOF" type="button"> <i class="fas fa-desktop" disabled></i> Gerar OF </button>
                                    </div>
                                </div>
                                <div class="col-sm-12 table-responsive card-body" style="height: 72.5vh">
                                    <table id="tabelaProdutos" class="table table-sm-sisp table-select table-hover" width="100%" style="white-space: nowrap; width:100%">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="divTabelaPedidos" role="tabpanel" aria-labelledby="tabTabelaPedidos">
                            <div class="row card form-group">
                                <div class="col-12 d-flex justify-content-between" style="margin-top: 8px; padding-left: 20px; padding-right: 20px; z-index:9999;">
                                    <div class="d-flex align-items-center" style="z-index:9999 !important">
                                        <button class="btn btn-sisp btn-danger" id="btnImprimirPedidos"><i class="fas fa-print"></i> Imprimir</button>
                                    </div>
                                </div>
                                <div class="col-sm-12 table-responsive card-body" style="height: 72.5vh">
                                    <table id="tabelaPedidos" class="table table-sm-sisp table-select table-hover" width="100%" style="white-space: nowrap; width:100%">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane fade show" id="divTabelaConsumos" role="tabpanel" aria-labelledby="tabTabelaConsumos">
                            <div class="card">
                                <div class="col-sm-12 table-responsive card-body" style="height: 78vh">
                                    <table id="tabelaConsumos" class="table table-sm table-select table-hover" style="white-space: nowrap;" width="100%"></table>
                                    <thead>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="modal-gerarOF" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header">
                        <h4 class="modal-title">Gerar OF</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-4 col-sm-12 col-lg-4" id="PeriodoGerarOFInfoTour">
                                <label data-error="wrong" data-success="right" for="txtPeriodoGerarOF">Periodo Gerar OF </label>
                                <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtPeriodoGerarOF" name="txtPeriodoGerarOF" class="form-control" placeholder="PeriodoGerarOF" required>
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnPeriodoGerarOF" name="btnPeriodoGerarOF" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaPeriodoGerarOF" name="btnLimpaPeriodoGerarOF" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4" id="ProgramacaoInfoTour">
                                <label data-error="wrong" data-success="right" for="txtProgramacao">Programação </label>
                                <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtProgramacao" name="txtProgramacao" class="form-control" placeholder="Programação">
                                </div>
                            </div>
                            <div class="col-4 col-sm-12 col-lg-4" id="DepositoGerarOFInfoTour">
                                <label data-error="wrong" data-success="right" for="txtDepositoGerarOF">Depósito </label>
                                <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtDepositoGerarOF" name="txtDepositoGerarOF" class="form-control" placeholder="Depósito">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnDepositoGerarOF" name="btnDepositoGerarOF" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaDepositoGerarOF" name="btnLimpaDepositoGerarOF" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4 col-sm-12 col-lg-4" id="TipoGerarOFInfoTour">
                                <label data-error="wrong" data-success="right" for="txtTipoGerarOF">Tipo </label>
                                <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtTipoGerarOF" name="txtTipoGerarOF" class="form-control" placeholder="Tipo">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnTipoGerarOF" name="btnTipoGerarOF" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaTipoGerarOF" name="btnLimpaTipoGerarOF" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4" id="ObsGerarOFInfoTour">
                                <label data-error="wrong" data-success="right" for="txtObsGerarOF">Obs </label>
                                <div class="input-group">
                                    <textarea style="resize: none" class="input-default form-control" id="txtObsGerarOF" cols="50" rows="4"></textarea>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12 col-4">
                                <div class="form" id="GerarOFPor" style="margin-top: 19px;">
                                    <fieldset class="form border-Field">
                                        <legend class="textoBorda mb-0 pb-0">Gerar OF por</legend>
                                        <div class="form-row ml-auto">
                                            <div class="icheck-primary form-group form-check col-12">
                                                <input type="radio" id="rdGrade" checked name="rdFiltroGerarOFPor" value="0">
                                                <label class="labelCheck" for="rdGrade">Grade</label>
                                            </div>
                                            <div class="icheck-primary form-group form-check col-12">
                                                <input type="radio" id="rdCor" name="rdFiltroGerarOFPor" value="1">
                                                <label class="labelCheck" for="rdCor">Cor</label>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12 col-4">
                                <div class="icheck-primary form-group form-check">
                                    <input type="checkbox" class="LancarFaccao" id="cbLancarFaccao" checked>
                                    <label class="labelCheck" for="cbLancarFaccao"> Lançar Facção</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="row">
                            <button class="btn btn-primary btn-sisp" id="btnConfirmarGerarOF"><span class="fas fa-check"></span> Confirmar</button>
                            <button class="btn btn-secondary btn-sisp marginBtnH" id="btnFecharGerarOF"><span class="fas fa-times"></span> Fechar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="modal-calculo" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header">
                        <h4 class="modal-title">Configura Cálculo</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-9 col-12" id="MensagemCalculoInfoTour">
                                <div class="row">
                                    <div class="col-6 col-sm-12 col-lg-6" id="NomeCalculoInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtNomeCalculo">Nome </label>
                                        <div class="input-group">
                                            <input type="text" autocomplete="off" class="input-default focus form-control campoCalculo" id="txtNomeCalculo" name="txtNomeCalculo" class="form-control" disabled>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-12 col-lg-6" id="MensagemCalculoInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtMensagemCalculo">Mensagem Filtros </label>
                                        <div class="input-group">
                                            <input type="text" autocomplete="off" class="input-default focus form-control campoCalculo" id="txtMensagemCalculo" name="txtMensagemCalculo" class="form-control" placeholder="Mensagem Filtros" disabled>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-lg-12" id="CalculoInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtCalculo">Cálculo </label>
                                        <div class="input-group">
                                            <input type="text" autocomplete="off" class="input-default focus form-control campoCalculo" id="txtCalculo" name="txtCalculo" class="form-control" placeholder="Cálculo" disabled>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-12" id="MensagemCalculoInfoTour">
                                <div class="form" id="OpcoesCalculoOf" style="margin-top: 18px;">
                                    <fieldset class="form border-Field">
                                        <legend class="textoBorda mb-0 pb-0">Opções</legend>
                                        <div class="form-row ml-auto">
                                            <div class="col-12 m-1">
                                                <div class="icheck-primary form-group form-check">
                                                    <input type="checkbox" class="configCheckOpcCalculo campoCalculo" id="cbMultiplicar" disabled>
                                                    <label class="labelCheck" for="cbMultiplicar"> Multiplicar</label>
                                                </div>
                                                <div class="icheck-primary form-group form-check">
                                                    <input type="checkbox" class="configCheckOpcCalculo campoCalculo" id="cbValidarNegativo" disabled>
                                                    <label class="labelCheck" for="cbValidarNegativo"> Validar negativos</label>
                                                </div>
                                                <div class="icheck-primary form-group form-check">
                                                    <input type="checkbox" class="configCheckOpcCalculo campoCalculo" id="cbZerarNegativos" disabled>
                                                    <label class="labelCheck" for="cbZerarNegativos"> Zerar negativos</label>
                                                </div>
                                                <!-- <div class="icheck-primary form-group form-check">
                                                    </div> -->
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12 col-12 p-0" id="camposCalculoInfoTour">
                                <div class="col-12">
                                    <fieldset class="form border-Field">
                                        <legend class="textoBorda mb-0 pb-0">Campos Cálculo</legend>
                                        <div class="row">
                                            <div class="col-4" id="cbCampoManual">
                                                <label data-error="wrong" data-success="right" for="cbCampoCampos">Campo </label>
                                                <div class="input-group" style="margin-bottom: 18px;">
                                                    <select class="form-control select2 select2-danger focus campoCalculo" id="cbCampoCampos" name="cbCampoCampos" data-dropdown-css-class="select2-danger" disabled>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-2 d-none" id="campoManual">
                                                <label data-error="wrong" data-success="right" for="txtCampoManual">Campo Manual </label>
                                                <div class="input-group" style="margin-bottom: 18px;">
                                                    <input type="text" class="input-default focus form-control campoCalculo" id="txtCampoManual">
                                                </div>
                                            </div>
                                            <div class="col-3">
                                                <label data-error="wrong" data-success="right" for="cbOperacaoCampos">Operação </label>
                                                <div class="input-group" style="margin-bottom: 18px;">
                                                    <select class="form-control select2 select2-danger focus campoCalculo" id="cbOperacaoCampos" name="cbOperacaoCampos" data-dropdown-css-class="select2-danger" disabled>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-3">
                                                <label data-error="wrong" data-success="right" for="cbParentesesCampos">Parênteses </label>
                                                <div class="input-group" style="margin-bottom: 18px;">
                                                    <select class="form-control select2 select2-danger focus campoCalculo" id="cbParentesesCampos" name="cbParentesesCampos" data-dropdown-css-class="select2-danger" disabled>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-2">
                                                <button class="btn btn-primary campoCalculo" id="btnAddCamposCalculo" style="height: 38px; width: 38px; font-size: 1.25em; margin-bottom: -69px;" disabled>
                                                    <i class="fa fa-plus d-flex justify-content-center align-items-center d-flex justify-content-center align-items-center"></i>
                                                </button>
                                                <button class="btn btn-danger campoCalculo" id="btnDelCamposCalculo" style="height: 38px; width: 38px; font-size: 1.25em; margin-bottom: -69px;" disabled>
                                                    <i class="fa fa-ban d-flex justify-content-center align-items-center d-flex justify-content-center align-items-center"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12 p-0" id="filtrosCalculoInfoTour">
                                <div class="col-12">
                                    <fieldset class="form border-Field">
                                        <legend class="textoBorda mb-0 pb-0">Filtros Cálculo</legend>
                                        <div class="row">
                                            <div class="col-3">
                                                <label data-error="wrong" data-success="right" for="cbCampoFiltros">Campo </label>
                                                <div class="input-group" style="margin-bottom: 18px;">
                                                    <select class="form-control select2 select2-danger focus camposFiltros" id="cbCampoFiltros" name="cbCampoFiltros" data-dropdown-css-class="select2-danger" disabled>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-3">
                                                <label data-error="wrong" data-success="right" for="cbOperacaoFiltros">Operação </label>
                                                <div class="input-group" style="margin-bottom: 18px;">
                                                    <select class="form-control select2 select2-danger focus camposFiltros" id="cbOperacaoFiltros" name="cbOperacaoFiltros" data-dropdown-css-class="select2-danger" disabled>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-4" id="cbValorManual">
                                                <label data-error="wrong" data-success="right" for="cbValorFiltros">Valor </label>
                                                <div class="input-group" style="margin-bottom: 18px;">
                                                    <select class="form-control select2 select2-danger focus camposFiltros" id="cbValorFiltros" name="cbValorFiltros" data-dropdown-css-class="select2-danger" disabled>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-2 d-none" id="ValorManual">
                                                <label data-error="wrong" data-success="right" for="txtValorManual">Valor Manual </label>
                                                <div class="input-group" style="margin-bottom: 18px;">
                                                    <input type="text" class="input-default focus form-control campoCalculo" id="txtValorManual">
                                                </div>
                                            </div>
                                            <div class="col-2">
                                                <button class="btn btn-primary camposFiltros" id="btnAddFiltrosCalculo" style="height: 38px; width: 38px; font-size: 1.25em; margin-bottom: -69px;" disabled>
                                                    <i class="fa fa-plus d-flex justify-content-center align-items-center d-flex justify-content-center align-items-center"></i>
                                                </button>
                                                <button class="btn btn-danger camposFiltros" id="btnDelFiltrosCalculo" style="height: 38px; width: 38px; font-size: 1.25em; margin-bottom: -69px;" disabled>
                                                    <i class="fa fa-ban d-flex justify-content-center align-items-center d-flex justify-content-center align-items-center"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12 p-0" id="filtrosTabCalculoInfoTour">
                                <div class="col-12">
                                    <fieldset class="form border-Field">
                                        <legend class="textoBorda mb-0 pb-0">Cálculos</legend>
                                        <div class="col-sm-12 table-responsive card-body">
                                            <table id="tabelaCalculos" class="table table-responsive-sm table-select table-hover" style="white-space: nowrap;" width="100%"></table>
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="col-lg-7 col-7 p-0" id="filtrosTabCamposInfoTour">
                                <div class="col-12">
                                    <fieldset class="form border-Field">
                                        <legend class="textoBorda mb-0 pb-0">Campos Cálculo</legend>
                                        <div class="col-sm-12 table-responsive card-body">
                                            <table id="tabelaCamposCalculos" class="table table-responsive-sm table-select table-hover" style="white-space: nowrap;" width="100%"></table>
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="col-lg-5 col-5 p-0" id="filtrosTabFiltrosInfoTour">
                                <div class="col-12">
                                    <fieldset class="form border-Field">
                                        <legend class="textoBorda mb-0 pb-0">Filtros Cálculo</legend>
                                        <div class="col-sm-12 table-responsive card-body">
                                            <table id="tabelaFiltrosCalculos" class="table table-responsive-sm table-select table-hover" style="white-space: nowrap;" width="100%"></table>
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-start">
                        <button class="btn btn-primary btn-sisp" id="btnIncluirCalculo">Incluir</button>
                        <button class="btn btn-danger btn-sisp" id="btnExcluirCalculo">Excluir</button>
                        <button class="btn btn-primary btn-sisp d-none" id="btnGravarCalculo">Gravar</button>
                        <button class="btn btn-secondary btn-sisp" id="btnAlterarCalculo">Alterar</button>
                        <button class="btn btn-danger btn-sisp d-none" id="btnCancelarCalculo">Cancelar</button>
                        <button class="ml-auto btn bg-gradient-danger btn-sisp" data-dismiss="modal">Fechar</button>
                    </div>
                </div>
            </div>
        </div>
        <div id="modal-gerarProjecao" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header">
                        <h4 class="modal-title">Gerar Projeção</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-4 col-sm-12 col-lg-4" id="PeriodoGerarOFInfoTour">
                                <label data-error="wrong" data-success="right" for="txtProjecaoProj">Projeção </label>
                                <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtProjecaoProj" name="txtProjecaoProj" class="form-control" disabled>
                                </div>
                            </div>
                            <div class="col-4 col-sm-12 col-lg-4" id="PeriodoProjInfoTour">
                                <label data-error="wrong" data-success="right" for="txtPeriodoProj">Periodo </label>
                                <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtPeriodoProj" name="txtPeriodoProj" class="form-control" placeholder="Periodo" required>
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnPeriodoProj" name="btnPeriodoProj" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaPeriodoProj" name="btnLimpaPeriodoProj" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4 col-sm-12 col-lg-4" id="ColecaoProjInfoTour">
                                <label data-error="wrong" data-success="right" for="txtColecaoProj">Coleção </label>
                                <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtColecaoProj" name="txtColecaoProj" class="form-control" placeholder="Coleção" required>
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnColecaoProj" name="btnColecaoProj" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaColecaoProj" name="btnLimpaColecaoProj" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4" id="DescricaoProjInfoTour">
                                <label data-error="wrong" data-success="right" for="txtDescricaoProj">Descrição </label>
                                <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtDescricaoProj" name="txtDescricaoProj" class="form-control" placeholder="Descrição">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="row">
                            <button class="btn btn-primary btn-sisp" id="btnConfirmarProj"><span class="fas fa-check"></span> Confirmar</button>
                            <button class="btn btn-secondary btn-sisp marginBtnH" id="btnFecharProj"><span class="fas fa-times"></span> Fechar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header">
                        <h4 class="modal-title">Filtros
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body py-1 px-0">
                        <div class="card-body pt-0 pb-0">
                            <div class="row">
                                <div class="col-12">
                                    <div class="row mt-2">
                                        <div class="row col-12">
                                            <div class="form-group col-4">
                                                <label for="dtFatPedidoDe">Faturamento Pedido de/até </label>
                                                <div class="input-group">
                                                <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtFatPedidoDe" value="1200-01-01" name="dtFatPedidoDe">
                                                <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtFatPedidoAte" value="2500-12-31" name="dtFatPedidoAte">
                                                </div>
                                            </div>
                                            <div class="form-group col-4">
                                                <label for="dtEmissaoPedidoDe">Emissão Pedido de/até </label>
                                                <div class="input-group">
                                                <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtEmissaoPedidoDe" value="1200-01-01" name="dtEmissaoPedidoDe">
                                                <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtEmissaoPedidoAte" value="2500-12-31" name="dtEmissaoPedidoAte">
                                                </div>
                                            </div>
                                            <!-- <div class="col-xl-2 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="dtEntregaPedidoDe">Entrega Pedido de </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="date" max="2500-12-31" class="input-default focus form-control" value="1200-01-01" id="dtEntregaPedidoDe" name="dtEntregaPedidoDe" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-2 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="dtEntregaPedidoAte">Até </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="date" max="2500-12-31" class="input-default focus form-control" value="2500-12-31" id="dtEntregaPedidoAte" name="dtEntregaPedidoAte" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-2 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="dtFinalizacaoOFDe">Finalização OF de </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="date" max="2500-12-31" class="input-default focus form-control" value="1200-01-01" id="dtFinalizacaoOFDe" name="dtFinalizacaoOFDe" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-2 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="dtFinalizacaoOFAte">Até </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="date" max="2500-12-31" class="input-default focus form-control" value="2500-12-31" id="dtFinalizacaoOFAte" name="dtFinalizacaoOFAte" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-2 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="dtEmissaoOFDe">Emissão OF de </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="date" max="2500-12-31" class="input-default focus form-control" value="1200-01-01" id="dtEmissaoOFDe" name="dtEmissaoOFDe" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-2 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="dtEmissaoOFAte">Até </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="date" max="2500-12-31" class="input-default focus form-control" value="2500-12-31" id="dtEmissaoOFAte" name="dtEmissaoOFAte" class="form-control">
                                                    </div>
                                                </div>
                                            </div> -->
                                            <div class="form-group col-4">
                                                <label for="dtVendasLojaDe">Venda Loja de/até </label>
                                                <div class="input-group">
                                                <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtVendasLojaDe" value="1200-01-01" name="dtVendasLojaDe">
                                                <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtVendasLojaAte" value="2500-12-31" name="dtVendasLojaAte">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtProduto">Produto </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtSetor">Setor</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtSetor" name="txtSetor" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnSetor" name="btnSetor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaSetor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtColecao">Coleção</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtColecao" name="txtColecao" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnColecao" name="btnColecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaColecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtSubGrupoConsFT">Sub Grupo Cons. FT </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtSubGrupoConsFT" name="txtSubGrupoConsFT" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnSubGrupoConsFT" name="btnSubGrupoConsFT" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaSubGrupoConsFT" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <div class="col-xl-4 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtDeposito">Depósito </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtDeposito" name="txtDeposito" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnDeposito" name="btnDeposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaDeposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtMaterialConsFT">Material Cons. FT: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtMaterialConsFT" name="txtMaterialConsFT" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnMaterialConsFT" name="btnMaterialConsFT" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaMaterialConsFT" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <!-- </div>
                                        <div class="row col-12"> -->
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtStatusPed">Status Ped. </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtStatusPed" name="txtStatusPed" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnStatusPed" name="btnStatusPed" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaStatusPed" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtPrazoProdPedido">Prazo Prod. Pedido </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtPrazoProdPedido" name="txtPrazoProdPedido" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnPrazoProdPedido" name="btnPrazoProdPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaPrazoProdPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtGrupoConsFT">Grupo Cons. FT </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtGrupoConsFT" name="txtGrupoConsFT" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnGrupoConsFT" name="btnGrupoConsFT" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaGrupoConsFT" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <!-- </div>
                                        <div class="row col-12"> -->
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtTipoVenda">Tipo Venda </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtTipoVenda" name="txtTipoVenda" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnTipoVenda" name="btnTipoVenda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaTipoVenda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtCorConsFT">Cor Cons. FT: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtCorConsFT" name="txtCorConsFT" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnCorConsFT" name="btnCorConsFT" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaCorConsFT" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtProdConsFT">Prod. Cons. FT: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtProdConsFT" name="txtProdConsFT" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnProdConsFT" name="btnProdConsFT" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaProdConsFT" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtMarca">Marca </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtMarca" name="txtMarca" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnMarca" name="btnMarca" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaMarca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtEtiqueta">Etiqueta </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtEtiqueta" name="txtEtiqueta" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnEtiqueta" name="btnEtiqueta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaEtiqueta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtQualidade">Qualidade </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtQualidade" name="txtQualidade" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnQualidade" name="btnQualidade" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaQualidade" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <!-- </div>
                                        <div class="row col-12"> -->
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtGrupoProdFT">Grupo Prod. FT </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtGrupoProdFT" name="txtGrupoProdFT" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnGrupoProdFT" name="btnGrupoProdFT" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaGrupoProdFT" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtStatusProd">Status Prod. </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtStatusProd" name="txtStatusProd" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnStatusProd" name="btnStatusProd" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaStatusProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtGrupoProd">Grupo Prod. </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtGrupoProd" name="txtGrupoProd" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnGrupoProd" name="btnGrupoProd" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaGrupoProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtLinhaProd">Linha Prod. </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtLinhaProd" name="txtLinhaProd" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnLinhaProd" name="btnLinhaProd" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaLinhaProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtFaixaDesc">Faixa Desc. </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtFaixaDesc" name="txtFaixaDesc" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnFaixaDesc" name="btnFaixaDesc" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaFaixaDesc" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtTipoOF">Tipo OF </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtTipoOF" name="txtTipoOF" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnTipoOF" name="btnTipoOF" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaTipoOF" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <!-- </div>
                                        <div class="row col-12"> -->
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtSubColecao">SubColeção </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtSubColecao" name="txtSubColecao" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnSubColecao" name="btnSubColecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaSubColecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtCorProd">Cor Prod. </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtCorProd" name="txtCorProd" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnCorProd" name="btnCorProd" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaCorProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtClienteProd">Cliente Prod.</label>
                                                <div class="input-group">
                                                    <select class="js-example-programmatic js-states form-control" id="txtClienteProd" name="txtClienteProd" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnClienteProd" name="btnClienteProd" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaClienteProd" name="btnLimpaClienteProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtCategoria">Categoria </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtCategoria" name="txtCategoria" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnCategoria" name="btnCategoria" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaCategoria" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtPedido">Pedido </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtPedido" name="txtPedido" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnPedido" name="btnPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtTipo">Tipo</label>
                                                <div class="input-group">
                                                    <select class="js-example-programmatic js-states form-control" id="txtTipo" name="txtTipo" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnTipo" name="btnTipo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaTipo" name="btnLimpaTipo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- </div>
                                        <div class="row col-12"> -->
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtPrazoOF">Prazo OF </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtPrazoOF" name="txtPrazoOF" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnPrazoOF" name="btnPrazoOF" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaPrazoOF" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtProgramacao">Programação </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtProgramacao" name="txtProgramacao" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnProgramacao" name="btnProgramacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaProgramacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtRamoAtividade">Ramo Atividade</label>
                                                <div class="input-group">
                                                    <select class="js-example-programmatic js-states form-control" id="txtRamoAtividade" name="txtRamoAtividade" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnRamoAtividade" name="btnRamoAtividade" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaRamoAtividade" name="btnLimpaRamoAtividade" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div> -->
                                        </div>
                                        <div class="row col-12">
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtSegmento">Segmento </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtSegmento" name="txtSegmento" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnSegmento" name="btnSegmento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaSegmento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtPrazoProd">Prazo Prod. </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtPrazoProd" name="txtPrazoProd" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnPrazoProd" name="btnPrazoProd" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaPrazoProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtTamanho">Tamanho</label>
                                                <div class="input-group">
                                                    <select class="js-example-programmatic js-states form-control" id="txtTamanho" name="txtTamanho" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnTamanho" name="btnTamanho" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaTamanho" name="btnLimpaTamanho" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- </div>
                                        <div class="row col-12"> -->
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtGrupoCliente">Grupo Cliente </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtGrupoCliente" name="txtGrupoCliente" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnGrupoCliente" name="btnGrupoCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaGrupoCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtGrupoPedido">Grupo Pedido </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtGrupoPedido" name="txtGrupoPedido" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnGrupoPedido" name="btnGrupoPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaGrupoPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtFamilia">Família (ProdCor)</label>
                                                <div class="input-group">
                                                    <select class="js-example-programmatic js-states form-control" id="txtFamilia" name="txtFamilia" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnFamilia" name="btnFamilia" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaFamilia" name="btnLimpaFamilia" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div> -->
                                        </div>
                                        <div class="row col-12">
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtFio">Fio </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtFio" name="txtFio" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnFio" name="btnFio" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaFio" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtTpVendaFat">Tp Venda Fat. </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtTpVendaFat" name="txtTpVendaFat" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnTpVendaFat" name="btnTpVendaFat" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaTpVendaFat" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtProdClasTipo">Tipo e Classificação</label>
                                                <div class="input-group">
                                                    <select class="js-example-programmatic js-states form-control" id="txtProdClasTipo" name="txtProdClasTipo" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnProdClasTipo" name="btnProdClasTipo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaProdClasTipo" name="btnLimpaProdClasTipo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div> -->
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtProjecao">Projeção </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" autocomplete="off" class="input-default focus form-control validate" id="txtProjecao" name="txtProjecao" required placeholder="Projeção">
                                                        <!-- <select class="js-example-programmatic js-states form-control" id="txtProjecao" name="txtProjecao" multiple="multiple"></select> -->
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnProjecao" name="btnProjecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaProjecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtListaPedido">Lista de Pedidos </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtListaPedido" name="txtListaPedido" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btnListaPedido" name="btnListaPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btnLimpaListaPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- <div class="col-xl-4 col-12 form-group">
                                                <label>Empresa</label>
                                                <div class="input-group">
                                                    <select class="form-control select2 select2-danger focus" id="selectEmpresa" name="selectEmpresa" data-dropdown-css-class="select2-danger">
                                                    </select>
                                                </div>
                                            </div> -->
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-lg-2 col-sm-12 col-12">
                                                <div class="form" id="Comercial">
                                                    <fieldset class="form border-Field">
                                                        <legend class="textoBorda mb-0 pb-0">Comercial</legend>
                                                        <div class="form-row ml-auto">
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdComTodos" checked name="rdFiltroComercial" value="0">
                                                                <label class="labelCheck" for="rdComTodos">Todos</label>
                                                            </div>
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdComLiberados" name="rdFiltroComercial" value="1">
                                                                <label class="labelCheck" for="rdComLiberados">Liberados</label>
                                                            </div>
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdComBloqueados" name="rdFiltroComercial" value="2">
                                                                <label class="labelCheck" for="rdComBloqueados">Bloqueados</label>
                                                            </div>
                                                    </fieldset>
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-sm-12 col-12">
                                                <div class="form" id="Financeiro">
                                                    <fieldset class="form border-Field">
                                                        <legend class="textoBorda mb-0 pb-0">Financeiro</legend>
                                                        <div class="form-row ml-auto">
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdFinTodos" checked name="rdFiltroFinanceiro" value="0">
                                                                <label class="labelCheck" for="rdFinTodos">Todos</label>
                                                            </div>
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdFinLiberados" name="rdFiltroFinanceiro" value="1">
                                                                <label class="labelCheck" for="rdFinLiberados">Liberados</label>
                                                            </div>
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdFinBloqueados" name="rdFiltroFinanceiro" value="2">
                                                                <label class="labelCheck" for="rdFinBloqueados">Bloqueados</label>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-sm-12 col-12">
                                                <div class="form" id="TipoPedido">
                                                    <fieldset class="form border-Field">
                                                        <legend class="textoBorda mb-0 pb-0">Tipo Pedido</legend>
                                                        <div class="form-row ml-auto">
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdTpPedidoTodos" checked name="rdFiltroTipoPedido" value="0">
                                                                <label class="labelCheck" for="rdTpPedidoTodos">Todos</label>
                                                            </div>
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdTpPedidoPai" name="rdFiltroTipoPedido" value="1">
                                                                <label class="labelCheck" for="rdTpPedidoPai">Pai</label>
                                                            </div>
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdTpPedidoFilho" name="rdFiltroTipoPedido" value="2">
                                                                <label class="labelCheck" for="rdTpPedidoFilho">Filho</label>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-sm-12 col-12">
                                                <div class="form" id="TipoVenda">
                                                    <fieldset class="form border-Field">
                                                        <legend class="textoBorda mb-0 pb-0">Tipo Venda</legend>
                                                        <div class="form-row ml-auto">
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdTpVendaTodos" checked name="rdFiltroTipoVenda" value="0">
                                                                <label class="labelCheck" for="rdTpVendaTodos">Todos</label>
                                                            </div>
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdTpVendaProducao" name="rdFiltroTipoVenda" value="1">
                                                                <label class="labelCheck" for="rdTpVendaProducao">Produção</label>
                                                            </div>
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdTpVendaRevenda" name="rdFiltroTipoVenda" value="2">
                                                                <label class="labelCheck" for="rdTpVendaRevenda">Revenda</label>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </div>
                                            </div>

                                            <!-- <div class="col-xl-4 col-12 form-group mt-2">
                                                <button id="btnCarregaEmpresas" class="btn btn-danger col-lg-12 col-md-12 col-12">Selecionar Empresas</button>
                                            </div> -->
                                        </div>
                                        <div class="row col-12">
                                            <!-- <div class="col-lg-3 col-sm-12 col-12">
                                                <div class="form" id="TipoDeOf">
                                                    <fieldset class="form border-Field">
                                                        <legend class="textoBorda mb-0 pb-0">Status Cor Produto</legend>
                                                        <div class="form-row ml-auto">
                                                            <div class="col-12">
                                                                <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbAtivo">
                                                                    <label class="labelCheck" for="cbAtivo"> Ativo</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbProdComRestricao">
                                                                    <label class="labelCheck" for="cbProdComRestricao"> Prod. com Restrição</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbCorBasica">
                                                                    <label class="labelCheck" for="cbCorBasica"> Cor Básica</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbCorAmostra">
                                                                    <label class="labelCheck" for="cbCorAmostra"> Cor Amostra</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </div>
                                            </div> -->
                                            <div class="col-lg-3 col-sm-12 col-12">
                                                <div class="form" id="TipoDeOf">
                                                    <fieldset class="form border-Field">
                                                        <legend class="textoBorda mb-0 pb-0">Opções</legend>
                                                        <div class="form-row ml-auto">
                                                            <div class="col-12">
                                                                <div class="icheck-primary form-group form-check" title="Buscar subprodutos de produtos filtrados.">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbBuscaProdutoFT">
                                                                    <label class="labelCheck" for="cbBuscaProdutoFT"> Buscar produtos FT</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check" title="Filtrar somente produtos que tenham pedidos no periodo selecionado. Obs. Verificar Parâmetro PCP 1010 pos. 12,1">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbProdutosPedido">
                                                                    <label class="labelCheck" for="cbProdutosPedido"> Produtos do pedido</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check" title="Filtrar somente produtos que estejam informados na projeção selecionada.">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbProdutosProjecao">
                                                                    <label class="labelCheck" for="cbProdutosProjecao"> Produtos de projeção</label>
                                                                </div>
                                                                <!-- <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbProducaoProjecao">
                                                                    <label class="labelCheck" for="cbProducaoProjecao"> Filtrar produção da projeção</label>
                                                                </div> -->
                                                                <!-- </div>
                                                            <div class="col-5"> -->
                                                                <!-- <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbDescTamProjecao">
                                                                    <label class="labelCheck" for="cbDescTamProjecao">Desconsiderar Tam na projeção</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbDetalhesProcesso">
                                                                    <label class="labelCheck" for="cbDetalhesProcesso"> Detalhes de processo</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbFiltraDepositoProducaoPedido">
                                                                    <label class="labelCheck" for="cbFiltraDepositoProducaoPedido"> Filtrar depósito produção e pedido</label>
                                                                </div> -->
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbBuscaVendaLoja">
                                                                    <label class="labelCheck" for="cbBuscaVendaLoja"> Buscar vendas loja</label>
                                                                </div>
                                                            </div>
                                                            <!-- <div class="col-3">
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbMetaColecao">
                                                                    <label class="labelCheck" for="cbMetaColecao"> Meta coleção</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbDataCarteira">
                                                                    <label class="labelCheck" for="cbDataCarteira"> Data carteira</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbSomenteComEstoque">
                                                                    <label class="labelCheck" for="cbSomenteComEstoque"> Somente com estoque</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbPedFaturado">
                                                                    <label class="labelCheck" for="cbPedFaturado"> Data Ped. faturado</label>
                                                                </div>
                                                            </div> -->
                                                        </div>
                                                    </fieldset>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-start pl-0">
                        <div class="row col-12">
                            <div class="col-md-4 col-sm-12 col-4">
                                <label for="txtOrdem">Opção de Relatório:</label>
                                <div class="relative d-flex align-items-center">
                                    <select id="txtOrdem" class="input-default focus custom-select">
                                    </select>
                                    <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                                <div class="d-flex">
                                    <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                                        <span class="fas fa-search"></span> Consultar
                                    </button>
                                    <button class="btn btn-danger btn-sisp marginBtnH" id="btnLimparFiltros">
                                        <span class="fas fa-trash"></span> Limpar Filtros
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside><!-- /.control-sidebar -->
        <?php include_once('../../modais.php'); ?>
    </main><!-- /.wrapper -->

    <script src="plugins/jquery/jquery.min.js?versao=3.2511.19.1"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.19.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2511.19.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2511.19.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.19.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.2511.19.1"></script>
    <script src="dist/js/sisplan.js?versao=3.2511.19.1"></script>
    <script src="utils/funcoes.js?versao=3.2511.19.1"></script>
    <script src="utils/cookies.js?versao=3.2511.19.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.2511.19.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.2511.19.1"></script>
    <script src="dist/js/driver.min.js?versao=3.2511.19.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.2511.19.1"></script>
    <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2511.19.1"></script>
    <script type="text/javascript" src="dist/js/sum().js?versao=3.2511.19.1"></script>
    <script type="text/javascript" src="config.js?versao=3.2511.19.1"></script>
    <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.2511.19.1"></script>
    <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.2511.19.1"></script>
    <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.2511.19.1"></script>
    <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.2511.19.1"></script>
    <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.2511.19.1"></script>
    <script src="plugins/select2/js/select2.full.min.js?versao=3.2511.19.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('PCPDEMANDA');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/pcpdemanda/pcpdemanda.js?versao=3.2511.19.1`;
            insereJavaScriptPagina(sArquivo);

        });
    </script>
</body>

</html>